// Génération des villes pour Bruxelles Capitale (15) et Wallonie/Flandre (50)
const villes15 = Array.from({ length: 15 }, (_, i) => `Ville ${i + 1}`);
const villes50 = Array.from({ length: 50 }, (_, i) => `Ville ${i + 1}`);

// Ajoute un sous-menu villes aux éléments donnés (containerUl)
function ajouterSousMenuVilles(containerUl, is15 = false) {
  const regions = [
  { name: 'Bruxelles Capitale', villes: is15 ? villes15 : villes50 },
  { name: 'Wallonie', villes: villes50 },
  { name: 'Flandre', villes: villes50 }];


  regions.forEach(region => {
    const liRegion = document.createElement('li');
    const aRegion = document.createElement('a');
    aRegion.href = '#';
    aRegion.textContent = region.name;
    aRegion.classList.add('has-submenu');
    liRegion.appendChild(aRegion);

    const ulVilles = document.createElement('ul');
    ulVilles.classList.add('submenu');

    region.villes.forEach(ville => {
      const liVille = document.createElement('li');
      const aVille = document.createElement('a');
      aVille.href = '#';
      aVille.textContent = ville;
      liVille.appendChild(aVille);
      ulVilles.appendChild(liVille);
    });

    liRegion.appendChild(ulVilles);
    containerUl.appendChild(liRegion);
  });
}

// Ajoute villes dans les éléments déjà créés (sélection par classes)
function remplirVilles() {
  // Serrurerie - Bruxelles Capitale (15 villes)
  document.querySelectorAll('.villes-list-15').forEach(ul => {
    ul.innerHTML = '';
    villes15.forEach(ville => {
      const li = document.createElement('li');
      const a = document.createElement('a');
      a.href = '#';
      a.textContent = ville;
      li.appendChild(a);
      ul.appendChild(li);
    });
  });

  // Serrurerie - Wallonie et Flandre (50 villes)
  document.querySelectorAll('.villes-list-50').forEach(ul => {
    ul.innerHTML = '';
    villes50.forEach(ville => {
      const li = document.createElement('li');
      const a = document.createElement('a');
      a.href = '#';
      a.textContent = ville;
      li.appendChild(a);
      ul.appendChild(li);
    });
  });

  // Pour Vitrerie, Chauffagiste, Plomberie, Electricité, Volet
  // Dans leurs Installation et Dépannage d'urgence : créer Bruxelles, Wallonie, Flandre puis 50 villes chacun
  document.querySelectorAll('.villes-list-50-parent').forEach(parentUl => {
    parentUl.innerHTML = ''; // vider avant

    ['Bruxelles Capitale', 'Wallonie', 'Flandre'].forEach(regionName => {
      const liRegion = document.createElement('li');
      const aRegion = document.createElement('a');
      aRegion.href = '#';
      aRegion.textContent = regionName;
      aRegion.classList.add('has-submenu');
      liRegion.appendChild(aRegion);

      const ulVilles = document.createElement('ul');
      ulVilles.classList.add('submenu');

      for (let i = 1; i <= 50; i++) {if (window.CP.shouldStopExecution(0)) break;
        const liVille = document.createElement('li');
        const aVille = document.createElement('a');
        aVille.href = '#';
        aVille.textContent = `Ville ${i}`;
        liVille.appendChild(aVille);
        ulVilles.appendChild(liVille);
      }window.CP.exitedLoop(0);

      liRegion.appendChild(ulVilles);
      parentUl.appendChild(liRegion);
    });
  });
}

// Gestion des clics pour ouvrir/fermer sous-menus au clic
function setupMenuToggle() {
  const hasSubmenus = document.querySelectorAll('.has-submenu');
  hasSubmenus.forEach(link => {
    link.addEventListener('click', function (e) {
      e.preventDefault();
      const submenu = link.nextElementSibling;
      if (!submenu) return;

      // Fermer les autres sous-menus au même niveau
      const siblings = Array.from(link.parentElement.parentElement.children);
      siblings.forEach(sib => {
        if (sib !== link.parentElement) {
          const sm = sib.querySelector('.submenu');
          if (sm) sm.style.display = 'none';
        }
      });

      if (submenu.style.display === 'block') {
        submenu.style.display = 'none';
      } else {
        submenu.style.display = 'block';
      }
    });
  });

  // Fermer les menus en cliquant ailleurs
  document.addEventListener('click', e => {
    if (!e.target.closest('nav')) {
      document.querySelectorAll('.submenu').forEach(sm => sm.style.display = 'none');
    }
  });
}

document.addEventListener('DOMContentLoaded', () => {
  remplirVilles();
  setupMenuToggle();
});