<?php
/*
Template Name: Page d'Accueil
*/
get_header(); ?>



  <main>
    <section class="hero">
      <div class="container">
        <h2>Votre dépannage d'urgence en un clic</h2>
        <p>Intervention rapide pour serrurerie, plomberie, électricité, et plus.</p>
        <a href="#" class="btn-primary">Demandez une intervention</a>
      </div>
    </section>

    <section class="services container">
      <h3>Nos Services</h3>
      <div class="service-list">
        <article class="service-card">
          <h4>Serrurerie</h4>
          <p>Ouverture de porte, changement de serrure, dépannage rapide.</p>
        </article>
        <article class="service-card">
          <h4>Plomberie</h4>
          <p>Fuites, débouchage, installation sanitaire d'urgence.</p>
        </article>
        <article class="service-card">
          <h4>Électricité</h4>
          <p>Dépannage électrique, panne de courant, sécurité.</p>
        </article>
        <article class="service-card">
          <h4>Vitrerie</h4>
          <p>Remplacement et réparation rapide de vitres cassées.</p>
        </article>
      </div>
    </section>

    <section class="contact-cta">
      <div class="container">
        <h3>Besoin d’une intervention immédiate ?</h3>
        <p>Appelez-nous au <a href="tel:+330123456789">01 23 45 67 89</a> ou envoyez un message via notre formulaire.</p>
        <a href="#" class="btn-secondary">Contactez-nous</a>
      </div>
    </section>
  </main>

 <?php if (have_posts()): while (have_posts()): the_post(); ?>
    <article class="indexPage">
        <h1><?php the_title(); ?></h1>
        <?php the_content() ?>
    </article>
 <?php endwhile; else: ?>
    <p>Aucun article :(</p>
 <?php endif; ?>

<?php get_footer() ?>