// Simple script to handle keyboard navigation for submenu accessibility

document.addEventListener('DOMContentLoaded', function() {
  const menu = document.querySelector('.menu');
  if (!menu) return;

  // Handle focus and blur to show/hide submenus for accessibility
  menu.querySelectorAll('li').forEach(item => {
    item.addEventListener('focusin', () => {
      item.classList.add('focus');
    });
    item.addEventListener('focusout', () => {
      item.classList.remove('focus');
    });
  });
});


document.addEventListener('DOMContentLoaded', function () {
  const elements = document.querySelectorAll('.animate-on-scroll');
  if (!elements.length) return;
  const observer = new IntersectionObserver((entries) => {
    entries.forEach((entry) => {
      if (entry.isIntersecting) {
        entry.target.classList.add('visible');
        observer.unobserve(entry.target);
      }
    });
  }, { threshold: 0.1 });
  elements.forEach((el) => observer.observe(el));
});

document.addEventListener('DOMContentLoaded', function () {
  const header = document.querySelector('.site-header');
  if (!header) return;

  window.addEventListener('scroll', function () {
    if (window.scrollY > 40) {
      header.classList.add('scrolled');
    } else {
      header.classList.remove('scrolled');
    }
  });
});
