<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php wp_title('|', true, 'right'); bloginfo('name'); ?></title>
  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<header class="site-header">
  <a href="tel:+0491887550" class="PhoneClick call-button" id="callButton">0491 88 75 50</a>

  <div class="container">
    <div class="site-branding">
      <a href="<?php echo home_url('/'); ?>" class="site-title"><?php bloginfo('name'); ?></a>
    </div>

    <nav class="site-navigation" aria-label="Menu principal">
      <?php
        wp_nav_menu([
          'theme_location' => 'primary',
          'menu_id'        => 'primary-menu',
          'depth'          => 6,
          'container'      => false,
          'menu_class'     => 'menu',
        ]);
      ?>
    </nav>

    <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false" aria-label="Ouvrir le menu">
      <span></span>
    </button>
  </div>
</header>
