<?php 

// Ajouter la prise en charge des images mises en avant
add_theme_support( 'post-thumbnails' );

// Ajouter automatiquement le titre du site dans l'en-tête du site
add_theme_support( 'title-tag' );

add_theme_support('custom-logo');

function custom_admin_posts_per_page($posts_per_page, $post_type) {
    // Vérifie si on est dans l'admin et que le post type est "post", "page" ou "regios"
    if (is_admin() && in_array($post_type, ['post', 'page', 'regios'])) {
        return 900;  // Remplace "900" par le nombre d'éléments que tu souhaites afficher
    }
    return $posts_per_page;
}
add_filter('edit_posts_per_page', 'custom_admin_posts_per_page', 10, 2);

function arphabet_widgets_init() {

	register_sidebar( array(
		'name' => 'Widget Footer',
		'id' => 'widget_footer',
		'before_widget' => '<li>',
		'after_widget' => '</li>',
		'before_title' => '<h2 class="rounded">',
		'after_title' => '</h2>',
	) );
}
add_action( 'widgets_init', 'arphabet_widgets_init' );
function register_my_menu(){
  register_nav_menu( 'main-menu', 'Menu principal' );
}
add_action( 'after_setup_theme', 'register_my_menu' );

function montheme_register_assets()
{
  wp_enqueue_style('load_css', get_theme_file_uri('/style.css'));
wp_enqueue_style('bootstrap-cdn-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css');
wp_enqueue_script('bootstrap-cdn-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js', 'jquery', false, true);

// wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
// wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array('parent-style') ); 
   
}
add_action('wp_enqueue_scripts', 'montheme_register_assets');

function montheme_supports()
{
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('menus');
    register_nav_menu('header', 'En tête du menu');
    register_nav_menu('footer', 'Pied de page');

    add_image_size('post-thumbnail', 350, 215, true);
}
add_action('after_setup_theme', 'montheme_supports');


function capitaine_register_assets() {
    
    // Déclarer jQuery
    wp_enqueue_script('jquery' );
    
    // Déclarer le JS
	wp_enqueue_script( 
        'capitaine', 
        get_template_directory_uri() . '/script.js', 
        array( 'jquery' ), 
        '1.0', 
        true
    );
    
    // Déclarer le fichier style.css à la racine du thème
    wp_enqueue_style( 
        'capitaine',
        get_stylesheet_uri(), 
        array(), 
        '1.0'
    );
  	
    // Déclarer le fichier CSS à un autre emplacement
    wp_enqueue_style( 
        'capitaine', 
        get_template_directory_uri() . '/style.css',
        array(), 
        '1.0'
    );
}
add_action( 'wp_enqueue_scripts', 'capitaine_register_assets' );



