<?php get_header(); ?>

<div class="imageArticleVilleHaut">
  <?php
    $term_id  = get_queried_object_id();
    $image_id = get_term_meta($term_id, 'category-image-id', true);

    if ($image_id) {
      echo wp_get_attachment_image($image_id, 'full');
    }
  ?>
</div>

<section class="hero animate-on-scroll">
	  <div class="overlay"></div>

  <div class="container">
    <h2>Dépannage immédiat !</h2>
    <p>Intervention rapide pour serrurerie, plomberie, électricité, et autres dépannages</p>
    <a class="btn-primary" href="#">Demandez une intervention</a>
  </div>
</section>

<!-- ✅ Wrapper commun : permet au sticky de s’arrêter avant le footer -->
<div class="content-with-sidebar">

  <main class="site-main container single">
 <?php depannage_breadcrumb(); ?>

    <article class="archiveCategorie">
      <h1><?php single_cat_title(); ?></h1>
    </article>

    <!-- ✅ Recherche ville AU-DESSUS de la description -->
    <?php rv_render_ville_search(); ?>

    <!-- ✅ Description de catégorie au-dessus des extraits -->
    <?php if ( category_description() ) : ?>
      <div class="category-description">
        <?php echo category_description(); ?>
      </div>
    <?php endif; ?>

    <section class="services container">

      <div class="service-list blog">
        <?php
          // ✅ 30 posts max par page + pagination
          $cat_id = get_queried_object_id();
          $paged  = max( 1, get_query_var('paged') );

          $all_posts = new WP_Query([
            'post_type'           => 'post',
            'posts_per_page'      => 30,
            'paged'               => $paged,
            'cat'                 => (int) $cat_id,
            'orderby'             => 'date',
            'order'               => 'DESC',
            'ignore_sticky_posts' => true,
          ]);

          if ($all_posts->have_posts()) :
            while ($all_posts->have_posts()) : $all_posts->the_post();
        ?>

          <article class="service-card animate-on-scroll" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <?php if (has_post_thumbnail()) : ?>
              <a href="<?php the_permalink(); ?>">
                <?php the_post_thumbnail(); ?>
              </a>
            <?php endif; ?>

            <h2>
              <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h2>

            <div class="entry-summary">
              <?php the_excerpt(); ?>
            </div>

          </article>

        <?php
            endwhile;
        ?>

          <!-- ✅ Pagination -->
          <div class="pagination">
            <?php
              echo paginate_links([
                'total'   => $all_posts->max_num_pages,
                'current' => $paged,
              ]);
            ?>
          </div>

        <?php
            wp_reset_postdata();
          else :
        ?>
          <p><?php _e(''); ?></p>
        <?php endif; ?>

      </div><!-- /.service-list.blog -->
    </section><!-- /.services.container -->

  </main>

  <aside class="sidebar">
    <?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
      <?php dynamic_sidebar( 'sidebar-1' ); ?>
    <?php endif; ?>
	  <!---<div id="sidebar-post-stream" class="sidebar-post-stream"></div>
<div id="sidebar-post-stream-sentinel" aria-hidden="true"></div>--->
  </aside>

</div><!-- /.content-with-sidebar -->

<?php get_footer(); ?>
