<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('hotlock_booked_theme_setup9')) {
	add_action( 'after_setup_theme', 'hotlock_booked_theme_setup9', 9 );
	function hotlock_booked_theme_setup9() {
		if (hotlock_exists_booked()) {
			add_action( 'wp_enqueue_scripts', 							'hotlock_booked_frontend_scripts', 1100 );
			add_filter( 'hotlock_filter_merge_styles',					'hotlock_booked_merge_styles' );
        }
        if (is_admin()) {
            add_filter( 'hotlock_filter_tgmpa_required_plugins',		'hotlock_booked_tgmpa_required_plugins' );
        }
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'hotlock_exists_booked' ) ) {
	function hotlock_exists_booked() {
		return class_exists('booked_plugin');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'hotlock_booked_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('hotlock_filter_tgmpa_required_plugins',	'hotlock_booked_tgmpa_required_plugins');
	function hotlock_booked_tgmpa_required_plugins($list=array()) {
		if (in_array('booked', (array)hotlock_storage_get('required_plugins'))) {
			$path = hotlock_get_file_dir('plugins/booked/booked.zip');
			$list[] = array(
						'name' 		=> esc_html__('Booked', 'hotlock'),
						'slug' 		=> 'booked',
						'source'	=> !empty($path) ? $path : 'upload://booked.zip',
						'required' 	=> false
			);
		}
		return $list;
	}
}

	
// Enqueue plugin's custom styles
if ( !function_exists( 'hotlock_booked_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'hotlock_booked_frontend_scripts', 1100 );
	function hotlock_booked_frontend_scripts() {
		if (hotlock_is_on(hotlock_get_theme_option('debug_mode')) && file_exists(hotlock_get_file_dir('plugins/booked/booked.css')))
			wp_enqueue_style( 'hotlock-booked',  hotlock_get_file_url('plugins/booked/booked.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'hotlock_booked_merge_styles' ) ) {
	//Handler of the add_filter('hotlock_filter_merge_styles', 'hotlock_booked_merge_styles');
	function hotlock_booked_merge_styles($list) {
		$list[] = 'plugins/booked/booked.css';
		return $list;
	}
}
?>