<?php
/**
 * The template for homepage posts with "Excerpt" style
 *
 * @package WordPress
 * @subpackage HOTLOCK
 * @since HOTLOCK 1.0
 */

hotlock_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	?><div class="posts_container"><?php
	
	$hotlock_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$hotlock_sticky_out = is_array($hotlock_stickies) && count($hotlock_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($hotlock_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	while ( have_posts() ) { the_post(); 
		if ($hotlock_sticky_out && !is_sticky()) {
			$hotlock_sticky_out = false;
			?></div><?php
		}
		get_template_part( 'content', $hotlock_sticky_out && is_sticky() ? 'sticky' : 'excerpt' );
	}
	if ($hotlock_sticky_out) {
		$hotlock_sticky_out = false;
		?></div><?php
	}
	
	?></div><?php

	hotlock_show_pagination();

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>