<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage HOTLOCK
 * @since HOTLOCK 1.0
 */

$hotlock_blog_style = explode('_', hotlock_get_theme_option('blog_style'));
$hotlock_columns = empty($hotlock_blog_style[1]) ? 2 : max(2, $hotlock_blog_style[1]);
$hotlock_post_format = get_post_format();
$hotlock_post_format = empty($hotlock_post_format) ? 'standard' : str_replace('post-format-', '', $hotlock_post_format);
$hotlock_animation = hotlock_get_theme_option('blog_animation');
$hotlock_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($hotlock_columns).' post_format_'.esc_attr($hotlock_post_format) ); ?>
	<?php echo (!hotlock_is_off($hotlock_animation) ? ' data-animation="'.esc_attr(hotlock_get_animation_classes($hotlock_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($hotlock_image[1]) && !empty($hotlock_image[2])) echo intval($hotlock_image[1]) .'x' . intval($hotlock_image[2]); ?>"
	data-src="<?php if (!empty($hotlock_image[0])) echo esc_url($hotlock_image[0]); ?>"
	>

	<?php
	$hotlock_image_hover = 'icon';	//hotlock_get_theme_option('image_hover');
	if (in_array($hotlock_image_hover, array('icons', 'zoom'))) $hotlock_image_hover = 'dots';
	// Featured image
	hotlock_show_post_featured(array(
		'hover' => $hotlock_image_hover,
		'thumb_size' => hotlock_get_thumb_size( strpos(hotlock_get_theme_option('body_style'), 'full')!==false || $hotlock_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. hotlock_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => false,
									'seo' => false,
									'share' => true,
									'counters' => 'comments',
									'echo' => false
									))
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'hotlock') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>