<?php get_header(); ?>

<?php
// Image de la première catégorie associée à l'article
$categories = get_the_category();

if (!empty($categories)) {
  $cat_id   = $categories[0]->term_id;
  $image_id = get_term_meta($cat_id, 'category-image-id', true);

  if ($image_id) {
    echo '<div class="article-category-image">';
    echo wp_get_attachment_image($image_id, 'full', false, array('class' => 'category-image'));
    echo '</div>';
  }
}
?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

  <h1 class="animate-on-scroll pageService"><?php the_title(); ?></h1>

  <section class="hero animate-on-scroll single">
    <div class="container">
      <h2>Dépannage immédiat !</h2>
      <p>Intervention rapide pour serrurerie, plomberie, électricité, et autres dépannages</p>
      <a class="btn-primary" href="#">Demandez une intervention</a>
    </div>
  </section>

  <!-- ✅ Wrapper commun : main + aside ensemble (sticky s’arrête avant le footer) -->
  <div class="content-with-sidebar">

    <main class="site-main container pageService single">

      <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

        <?php
        if (function_exists('yoast_breadcrumb')) {
          yoast_breadcrumb('<nav class="breadcrumbs" aria-label="Fil d\'Ariane">', '</nav>');
        }
        ?>

        <div class="entry-content">

          <?php if (has_post_thumbnail()) : ?>
            <div class="featured-image-container">
              <?php the_post_thumbnail('large', array('class' => 'featured-image')); ?>
            </div>
          <?php endif; ?>

          <?php the_content(); ?>

        </div>

        <footer class="post-footer">
          <p><?php echo get_the_date(); ?> | <?php the_category(', '); ?></p>
        </footer>

      </article>

      <?php
      if (comments_open() || get_comments_number()) {
        comments_template();
      }
      ?>

      <?php rv_render_ville_search(); ?>

    </main>

    <aside class="sidebar">
      <?php if (is_active_sidebar('sidebar-1')) : ?>
        <?php dynamic_sidebar('sidebar-1'); ?>
      <?php endif; ?>
    </aside>

  </div><!-- /.content-with-sidebar -->

<?php endwhile; else : ?>

  <p><?php _e('Article non trouvé.'); ?></p>

<?php endif; ?>

<?php get_footer(); ?>
