<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php wp_title('|', true, 'right'); bloginfo('name'); ?></title>
  <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<header class="site-header">
	<a href="tel:+0495991088" class="call-button" id="callButton">
  0495 99 10 88
</a>
  <div class="container">
    <div class="site-branding">
      <a href="<?php echo home_url('/'); ?>" class="site-title"><?php bloginfo('name'); ?></a>
    </div>
    <nav class="site-navigation">
      <?php
      wp_nav_menu([
        'theme_location' => 'primary',
        'menu_id'        => 'primary-menu',
        'depth'          => 6,
        'container'      => false,
        'menu_class'     => 'menu',
      ]);
      ?>
    </nav>
    <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><span></span></button>
  </div>
</header>
