<?php get_header(); ?>

<div class="imageArticleVilleHaut">
  <?php
    $term_id  = get_queried_object_id();
    $image_id = get_term_meta($term_id, 'category-image-id', true);

    if ($image_id) {
      echo wp_get_attachment_image($image_id, 'full');
    }
  ?>
</div>

<section class="hero animate-on-scroll">
  <div class="container">
    <h2>Dépannage immédiat !</h2>
    <p>Intervention rapide pour serrurerie, plomberie, électricité, et autres dépannages</p>
    <a class="btn-primary" href="#">Demandez une intervention</a>
  </div>
</section>

<!-- ✅ Wrapper commun : permet au sticky de s’arrêter avant le footer -->
<div class="content-with-sidebar">

  <main class="site-main container single">

    <article class="archiveCategorie">
      <h1><?php single_cat_title(); ?></h1>
    </article>

    <section class="services container">

      <?php rv_render_ville_search(); ?>

      <div class="service-list blog">
        <?php
          // ✅ Force l’affichage de TOUS les posts de la catégorie courante
          $cat_id = get_queried_object_id();

          $all_posts = new WP_Query([
            'post_type'           => 'post',
            'posts_per_page'      => -1,          // -1 = tous les articles
            'cat'                 => (int) $cat_id,
            'orderby'             => 'date',
            'order'               => 'DESC',
            'ignore_sticky_posts' => true,
            'no_found_rows'       => true,        // optimisation (pas de pagination)
          ]);

          if ($all_posts->have_posts()) :
            while ($all_posts->have_posts()) : $all_posts->the_post();
        ?>

          <article class="service-card animate-on-scroll" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <?php if (has_post_thumbnail()) : ?>
              <a href="<?php the_permalink(); ?>">
                <?php the_post_thumbnail(); ?>
              </a>
            <?php endif; ?>

            <h2>
              <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h2>

            <div class="entry-summary">
              <?php the_excerpt(); ?>
            </div>

          </article>

        <?php
            endwhile;
            wp_reset_postdata();
          else :
        ?>
          <p><?php _e('Aucun article trouvé.'); ?></p>
        <?php endif; ?>

        <?php echo category_description(); ?>

      </div><!-- /.service-list.blog -->
    </section><!-- /.services.container -->

  </main>

  <aside class="sidebar">
    <?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
      <?php dynamic_sidebar( 'sidebar-1' ); ?>
    <?php endif; ?>
  </aside>

</div><!-- /.content-with-sidebar -->

<?php get_footer(); ?>
