<?php

// Active la prise en charge des widgets
function mon_theme_widgets_init() {
    register_sidebar( array(
        'name'          => 'Barre latérale principale',
        'id'            => 'sidebar-1',
        'description'   => 'Zone de widgets affichée dans la barre latérale.',
        'before_widget' => '<div id="%1$s" class="widget %2$s animate-on-scroll">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
}
add_action( 'widgets_init', 'mon_theme_widgets_init' );


function depannage_setup() {
  // Support titre automatique
  add_theme_support('title-tag');

  // Support miniatures
  add_theme_support('post-thumbnails');

  // Menus
  register_nav_menus([
    'primary' => __('Menu Principal'),
  ]);

  // Support HTML5
  add_theme_support('html5', ['search-form', 'comment-form', 'comment-list', 'gallery', 'caption']);
}

add_action('after_setup_theme', 'depannage_setup');

function depannage_scripts() {
  wp_enqueue_style('depannage-style', get_stylesheet_uri());
  wp_enqueue_script('depannage-script', get_template_directory_uri() . '/script.js', ['jquery'], null, true);
}
add_action('wp_enqueue_scripts', 'depannage_scripts');

// Menu responsive toggle
function depannage_menu_toggle_script() {
  ?>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const toggle = document.querySelector('.menu-toggle');
      const menu = document.getElementById('primary-menu');
      toggle.addEventListener('click', () => {
        const expanded = toggle.getAttribute('aria-expanded') === 'true' || false;
        toggle.setAttribute('aria-expanded', !expanded);
        menu.classList.toggle('active');
      });
    });
  </script>
  <?php
}


// Ajoute un champ image dans le formulaire d'ajout de catégorie
add_action('category_add_form_fields', function() {
    ?>
    <div class="form-field term-group">
        <label for="category-image"><?php _e('Image de la catégorie', 'textdomain'); ?></label>
        <input type="hidden" id="category-image" name="category-image" class="custom_media_url">
        <div id="category-image-wrapper"></div>
        <p>
            <input type="button" class="button button-secondary custom_media_button" id="custom_media_button" value="<?php _e('Ajouter une image', 'textdomain'); ?>" />
            <input type="button" class="button button-secondary custom_media_remove" value="<?php _e('Supprimer l\'image', 'textdomain'); ?>" />
        </p>
    </div>
    <?php
});

// Ajoute un champ image dans le formulaire d’édition de catégorie
add_action('category_edit_form_fields', function($term) {
    $image_id = get_term_meta($term->term_id, 'category-image-id', true);
    ?>
    <tr class="form-field term-group-wrap">
        <th scope="row"><label for="category-image"><?php _e('Image de la catégorie', 'textdomain'); ?></label></th>
        <td>
            <input type="hidden" id="category-image" name="category-image" value="<?php echo esc_attr($image_id); ?>">
            <div id="category-image-wrapper">
                <?php if ($image_id) echo wp_get_attachment_image($image_id, 'thumbnail'); ?>
            </div>
            <p>
                <input type="button" class="button button-secondary custom_media_button" id="custom_media_button" value="<?php _e('Ajouter une image', 'textdomain'); ?>" />
                <input type="button" class="button button-secondary custom_media_remove" value="<?php _e('Supprimer l\'image', 'textdomain'); ?>" />
            </p>
        </td>
    </tr>
    <?php
});

// Sauvegarde de l’image lors de la création/édition
add_action('created_category', function($term_id) {
    if (isset($_POST['category-image']) && '' !== $_POST['category-image']) {
        update_term_meta($term_id, 'category-image-id', absint($_POST['category-image']));
    }
});

add_action('edited_category', function($term_id) {
    if (isset($_POST['category-image']) && '' !== $_POST['category-image']) {
        update_term_meta($term_id, 'category-image-id', absint($_POST['category-image']));
    } else {
        delete_term_meta($term_id, 'category-image-id');
    }
});

// Script JS pour le média uploader
add_action('admin_footer', function() {
    if (!isset($_GET['taxonomy']) || $_GET['taxonomy'] != 'category') return;
    ?>
    <script>
    jQuery(document).ready(function($){
        function mediaUpload(button_class) {
            var _custom_media = true,
                _orig_send_attachment = wp.media.editor.send.attachment;
            $('body').on('click', button_class, function(e) {
                var button_id = $(this).attr('id');
                var send_attachment_bkp = wp.media.editor.send.attachment;
                var button = $(this);
                _custom_media = true;
                wp.media.editor.send.attachment = function(props, attachment){
                    if (_custom_media) {
                        $('#category-image').val(attachment.id);
                        $('#category-image-wrapper').html('<img class="custom_media_image" src="'+attachment.sizes.thumbnail.url+'" style="max-width:150px;"/>');
                    } else {
                        return _orig_send_attachment.apply(this, [props, attachment]);
                    }
                }
                wp.media.editor.open(button);
                return false;
            });
        }
        mediaUpload('.custom_media_button');
        $('body').on('click', '.custom_media_remove', function(){
            $('#category-image').val('');
            $('#category-image-wrapper').html('');
        });
    });
    </script>
    <?php
});

add_action('wp_footer', 'depannage_menu_toggle_script');




/**
 * Recherche par ville (liste déroulante) + résultats
 * Affiche les articles dont le TITRE contient la ville sélectionnée
 *
 * Utilisation dans un template :
 *   <?php rv_render_ville_search(); ?>
 */


function rv_get_villes() {
    return [
        'Aalst','Aartselaar','Acoz','Alleur','Alsemberg','Amay','Amel-Amblève','Andenne','Anderlues','Anderlecht','Angreau','Angleur','Angre','Anhée','Annevoie-Rouillon','Ans','Anthisnes','Arquennes','Asquillies','Asse','Assesse','Ath','Athis','Auderghem','Audregnies','Aubel','Auvelais','Aulnois','Autreppe','Awans','Aywaille','Baisieux','Baelen','Bambois','Bassenge','Baudour','Bauffe','Baulers','Bavay','Beaufays','Beaumont','Beauraing','Beauvechain','Beez','Beersel','Belgrade','Beloeil','Bellecourt','Berchem-Sainte-Agathe','Bernissart','Berloz','Bertem','Bever','Beyne-Heusay','Bièvre','Bierbeek','Biesme','Binche','Blaregnies','Blaugies','Blegny','Bois d’Haine','Boncelles','Boninne','Boom','Boortmeerbeek','Bornem','Bouffioulx','Bouge','Bougnies','Boussu','Boussu-Bois','Boutersem','Braine-l\'Alleud','Braine-le-Château','Braine-le-Comte','Brakel','Braives','Bressoux','Brugelette','Brunehaut','Bruxelles','Bullange','Burdinne','Burg-Reuland','Buzet','Buvrinnes','Cambron-Saint-Vincent','Carnières','Cerfontaine','Champion','Chapelle-au-Bois','Chapelle-lez-Herlaimont','Charleroi','Chastre','Chastre-Villeroux-Blanmont','Châtelet','Châtelineau','Chaudfontaine','Chênée','Chimay','Ciney','Ciply','Clavier','Cognelee','Colfontaine','Comblain-au-Pont','Condroz','Couillet','Courcelles','Court-Saint-Etienne','Courtrai','Couvin','Crisnée','Cuesmes','Daussoulx','Dalhem','Dampremy','Darion','Dave','Denderleeuw','Deulin','Dilbeek','Dinant','Dison','Doische','Donceel','Dour','Drogenbos','Durbuy','Dworp','Écaussines','Écaussinnes-d\'Enghien','Eghezée','Ellemelle','Elouges','Enghien','Engis','Erbaut','Erbisoeul','Ermeton-Sur-Biert','Erpent','Erquennes','Erquelinnes','Esneux','Estinnes','Etterbeek','Eugies','Eupen','Evere','Faimes','Farciennes','Familleureux','Fayt-le-franc','Fayt-lez-Manage','Feluy','Fernelmont','Ferrières','Fexhe le haut Clocher','Flawinne','Flémalle','Flénu','Fléron','Fleurus','Florennes','Fontaine-l’Eveque','Forchies-La-Marche','Forest','Fosses-la-Ville','Fourons','Frameries','Frasnes-lez-Gosselies','Froidchapelle','Galmaarden','Ganshoren','Gedinne','Geer','Gelbressee','Gembloux','Genappe','Genly','Geraardsbergen','Gerpinnes','Gesve','Ghlin','Gilly','Givry','Glons','Goegnies-Chaussée','Gommegnies','Gosselies','Gougnies','Goutroux','Gouy-lez-Piéton','Grace-Hollogne','Grand Sart','Grimbergen','Grivegnée','Grez-Doiceau','Haacht','Haaltert','Ham sur Sambre','Hamme','Hamoir','Hamois','Hannut','Haren','Harmignies','Harveng','Hastière','Hastière-Lavaux','Hautrage','Havay','Havelange','Havré','Herchies','Herent','Herne','Héron','Hermée','Herve','Herstal','Hingeon','Honnelles','Horn u','Hotton','Houyet','Huldenberg','Huy','Incourt','Ittre','Ixelles','Jalhay','Jambes','Jemappes','Jemeppe-sur-Sambre','Jette','Jodoigne','Joncret','Jumet','Jupille sur Meuse','Juprelle','Jurbise','Kampenhout','Keerbergen','Kelmis','Koekelberg','Kontich','Kraainem','La Bouverie','La Bruyère','La Hestre','La Hulpe','La Louvière','La Roeulx','Lambusart','Landelies','Landen','Laneffe','Leernes','Lede','Ledeberg','Lennik','Lens','Lessines','Leuze-en-Hainaut','Liberchies','Ligny','Lierneux','Liers','Lies-sur-Meuse','Limelette','Lincent','Linkebeek','Lixhe','Lobbes','Lodelinsart','Lontzen','Louvain','Louvain-la-Neuve','Loverval','Loyers','Manage','Marchienne-au-Pont','Marchin','Marcinelle','Marche-les-Dames','Marneffe','Masnuy-Saint-Jean','Masnuy-Saint-Pierre','Maurage','Mazy','Meise','Mellet','Mellery','Merchtem','Mesvin','Mettet','Milmort','Modave','Monceau-sur-Sambre','Mons','Mont-Saint-Guibert','Mont-sur-Marchienne','Montignies-le-Tilleul','Montignies-lez-Lens','Montignies-sur-Roc','Morlanwelz','Mouscron','Namur','Nandrin','Neufmaison','Nimy','Nivelles','Nouvelles','Obaix','Obourg','Ohey','Olne','Onhaye','Onnezies','Opwijk','Oreye','Orp','Orp-Jauche','Ouffet','Ougrée','Ottignies','Ottignies-Louvain-la-Neuve','Outremeuse','Pepinster','Peruwelz','Perwez','Petit-Roeulx-le-Nivelles','Philippeville','Pont-à-Celles','Pont-de-Loup','Presles','Putte','Puurs','Quaregnon','Quévy','Quiévrain','Raeren','Ramillies','Ransart','Rebecq-Rognon','Remicourt','Renaix','Rhisnes','Rixensart','Rochefort','Rocourt','Rotselaar','Roucourt','Roux','Rumst','Saint-Amand','Saint-Denis','Saint-Georges-sur-Meuse','Saint-Ghislain','Saint-Gilles','Saint-Josse-Ten-Noode','Saint-Marc','Saint-Nicolas','Saint-Servais','Saint-Symphorien','Saint-Trond','Saint-Vith','Sambreville','Sars-la-Bruyere','Schaerbeek','Schelle','Schepdaal','Seneffe','Seraing','Silly','Sint-Amands','Sint-Martens-Lennik','Sint-Pieters-Leeuw','Slins','Soignies','Sombreffe','Somme-Leuze','Soumagne','Spa','Sprimont','Stavelot','Stoumont','Strépy-Bracquegnies','Suarlee','Tamines','Temse','Ternat','Tertre','Theux','Thimister-Clermont','Thuin','Tilleur','Tilff','Tinlot','Tongres','Tournai','Trois-Ponts','Trooz','Tubize','Tervuren','Uccle','Vedrin','Verlaine','Verviers','Viesville','Villers-la-Ville','Villers-le-Bouillet','Villers-Perwin','Villers-Poterie','Villerot','Ville-sur-Haine','Viroinval','Visé','Vodelée','Vottem','Waimes','Walcourt','Walhain-Saint-Paul','Wanze','Waremme','Wasseiges','Waterloo','Watermael-Boitsfort','Wauthier-Braine','Wavre','Wemmel','Wepion','Wetteren','Wezembeek-Oppem','Willebroek','Woluwe','Woluwe-Saint-Lambert','Woluwe-Saint-Pierre','Yvoir','Zaventem','Zele','Zellik','Zemst','Zottegem'

    ];
}






/** Nettoyage basique */
function rv_clean_ville($ville) {
    $ville = wp_strip_all_tags($ville);
    return trim($ville);
}

/**
 * Rend le bloc complet (formulaire + résultats)
 * @param array $args Options (facultatif)
 */
function rv_render_ville_search($args = []) {
    $defaults = [
        'posts_per_page' => 520,
        'post_type'      => 'post',
        'button_label'   => 'Rechercher',
        'label'          => 'Choisir une ville :',
        'placeholder'    => '- Ville -',
        'title_results'  => 'Nous intervenons bien à %s ! Appelez-nous au <a class="call-buttonForm PhoneClick" href="tel:0491887550">0491 88 75 50</a> ',
        'no_results'     => 'Aucun article trouvé dont le titre contient cette ville.',
        'invalid_city'   => 'Ville non valide.',
        'container_class'=> 'rv-wrap',
    ];
    $args = wp_parse_args($args, $defaults);

    $villes = rv_get_villes();

    // Ville sélectionnée via URL ?ville=...
    $selected = isset($_GET['ville']) ? rv_clean_ville(wp_unslash($_GET['ville'])) : '';

    // URL de la page courante
    $action_url = (function_exists('get_permalink') && get_queried_object_id())
        ? get_permalink(get_queried_object_id())
        : home_url(add_query_arg([]));

    echo '<div class="' . esc_attr($args['container_class']) . '">';

    // --- Formulaire
    ?>
    <form class="rv-form" method="get" action="<?php echo esc_url($action_url); ?>">
        <label for="rv-ville"><?php echo esc_html($args['label']); ?></label>

        <select name="ville" id="rv-ville" required>
            <option value=""><?php echo esc_html($args['placeholder']); ?></option>
            <?php foreach ($villes as $ville): ?>
                <option value="<?php echo esc_attr($ville); ?>" <?php selected($selected, $ville); ?>>
                    <?php echo esc_html($ville); ?>
                </option>
            <?php endforeach; ?>
        </select>

        <button class="rv-button" type="submit"><?php echo esc_html($args['button_label']); ?></button>
    </form>
    <?php

    // Si aucune ville choisie, on s’arrête ici
    if (empty($selected)) {
        echo '</div>';
        return;
    }

    // Optionnel mais conseillé : refuser une ville hors liste
    if (!in_array($selected, $villes, true)) {
        echo '<div class="rv-results"><p>' . esc_html($args['invalid_city']) . '</p></div>';
        echo '</div>';
        return;
    }

    // --- Résultats (recherche UNIQUEMENT dans le titre)
    $callback = function($where) use ($selected) {
        global $wpdb;
        $like = '%' . $wpdb->esc_like($selected) . '%';
        $where .= $wpdb->prepare(" AND {$wpdb->posts}.post_title LIKE %s ", $like);
        return $where;
    };
    add_filter('posts_where', $callback);

    $q = new WP_Query([
        'post_type'           => $args['post_type'],
        'post_status'         => 'publish',
        'posts_per_page'      => (int) $args['posts_per_page'],
        'ignore_sticky_posts' => true,
        'orderby'             => 'date',
        'order'               => 'DESC',
        's'                   => '', // on évite la recherche dans le contenu
        'no_found_rows'       => true,
    ]);

    remove_filter('posts_where', $callback);

    echo '<div class="rv-results">';
echo '<h3>' . wp_kses_post(sprintf($args['title_results'], esc_html($selected))) . '</h3>';

    if ($q->have_posts()) {
        echo '<ul>';
        while ($q->have_posts()) {
            $q->the_post();
            echo '<li><a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a></li>';
        }
        echo '</ul>';
    } else {
        echo '<p>' . esc_html($args['no_results']) . '</p>';
    }

    echo '</div>';

    wp_reset_postdata();

    echo '</div>';
}

/**
 * CSS : injecté automatiquement sur le front (option 1).
 * Si tu préfères le mettre dans style.css, tu peux supprimer cette fonction.
 */
function rv_enqueue_ville_search_css() {
    if (is_admin()) return;

    $css = <<<CSS
/* ===== Recherche Ville (rv) ===== */
.rv-form{
  --rv-radius: 14px;
  --rv-border: rgba(20, 20, 20, .12);
  --rv-shadow: 0 10px 30px rgba(0,0,0,.06);

  display: grid;
  grid-template-columns: 1fr;
  gap: 10px;

  padding: 16px;
  border: 1px solid var(--rv-border);
  border-radius: var(--rv-radius);
  background: rgba(255,255,255,.75);
  box-shadow: var(--rv-shadow);
  backdrop-filter: blur(8px);
  -webkit-backdrop-filter: blur(8px);
}

@media (min-width: 720px){
  .rv-form{
    grid-template-columns: auto 1fr auto;
    align-items: center;
    gap: 12px;
    padding: 18px;
  }
}

.rv-form label{
  font-weight: 600;
  font-size: 0.95rem;
  letter-spacing: .2px;
  opacity: .9;
}

.rv-form select{
  width: 100%;
  height: 44px;
  padding: 0 14px;
  border-radius: 12px;
  border: 1px solid var(--rv-border);
  background: #fff;
  font-size: 1rem;
  outline: none;
  transition: transform .15s ease, box-shadow .15s ease, border-color .15s ease;
  box-shadow: 0 1px 0 rgba(0,0,0,.02);
}

.rv-form select:hover{
  box-shadow: 0 8px 18px rgba(0,0,0,.06);
  transform: translateY(-1px);
}

.rv-form select:focus{
  border-color: rgba(0,0,0,.28);
  box-shadow: 0 0 0 4px rgba(0,0,0,.08);
  transform: translateY(-1px);
}

.rv-button{
  height: 44px;
  padding: 0 16px;
  border-radius: 12px;
  border: 1px solid rgba(0,0,0,.12);
  background: #111;
  color: #fff;
  font-weight: 650;
  font-size: .98rem;
  letter-spacing: .2px;
  cursor: pointer;
  transition: transform .15s ease, box-shadow .15s ease, opacity .15s ease;
  box-shadow: 0 12px 26px rgba(0,0,0,.16);
}

.rv-button:hover{
  transform: translateY(-1px);
  box-shadow: 0 16px 36px rgba(0,0,0,.20);
}

.rv-button:active{
  transform: translateY(0px);
  opacity: .92;
}

.rv-button:focus-visible{
  outline: none;
  box-shadow: 0 0 0 4px rgba(0,0,0,.12), 0 16px 36px rgba(0,0,0,.20);
}

.rv-results{
  margin-top: 18px;
  padding: 16px;
  border: 1px solid rgba(20,20,20,.10);
  border-radius: 14px;
  background: #fff;
  box-shadow: 0 10px 30px rgba(0,0,0,.06);
}

.rv-results h3{
  margin: 0 0 10px 0;
  font-size: 1.1rem;
}

.rv-results ul{
  list-style: none;
  padding: 0;
  margin: 10px 0 0 0;
  display: grid;
  gap: 8px;
}

.rv-results li a{
  display: block;
  padding: 12px 14px;
  border-radius: 12px;
  border: 1px solid rgba(0,0,0,.08);
  text-decoration: none;
  color: inherit;
  transition: transform .15s ease, box-shadow .15s ease;
}

.rv-results li a:hover{
  transform: translateY(-1px);
  box-shadow: 0 10px 22px rgba(0,0,0,.08);
}
CSS;

    // On attache le CSS à une feuille existante (le style principal du thème)
    $handle = 'rv-inline-style';
    wp_register_style($handle, false);
    wp_enqueue_style($handle);
    wp_add_inline_style($handle, $css);
}
add_action('wp_enqueue_scripts', 'rv_enqueue_ville_search_css');

/**
 * Affiche les résultats de recherche ville juste après le H1
 * (pages et articles uniquement)
 */
add_filter('the_content', function ($content) {

    // uniquement sur le front
    if (is_admin()) {
        return $content;
    }

    // uniquement pages + articles
    if (!is_page() && !is_single()) {
        return $content;
    }

    // seulement si une ville est sélectionnée
    if (empty($_GET['ville'])) {
        return $content;
    }

    // on génère le HTML du formulaire + résultats
    ob_start();
    rv_render_ville_search();
    $search_html = ob_get_clean();

   // on injecte AVANT le premier H1
if (preg_match('/(<h1[^>]*>.*?<\/h1>)/is', $content)) {
    $content = preg_replace(
        '/(<h1[^>]*>.*?<\/h1>)/is',
        $search_html . '$1',
        $content,
        1
    );
} else {
    // fallback si aucun H1
    $content = $search_html . $content;
}


    return $content;
});



function depannage_breadcrumb() {
    if (is_front_page()) return;

    echo '<nav class="breadcrumb">';
    echo '<a href="' . esc_url(home_url('/')) . '">Accueil</a>';

    // Article (single)
    if (is_single() && get_post_type() === 'post') {

        $cats = get_the_category();
        if (!empty($cats)) {

            // Prend la catégorie la plus "profonde" (souvent la sous-catégorie)
            usort($cats, function($a, $b){
                return $b->term_id <=> $a->term_id;
            });
            $cat = $cats[0];

            // Remonte les parents : Catégorie > Sous-catégorie
            $parents = array_reverse(get_ancestors($cat->term_id, 'category'));
            foreach ($parents as $parent_id) {
                $parent = get_term($parent_id, 'category');
                if ($parent && !is_wp_error($parent)) {
                    echo ' &raquo; <a href="' . esc_url(get_term_link($parent)) . '">' . esc_html($parent->name) . '</a>';
                }
            }

            // Catégorie actuelle (souvent sous-catégorie)
            echo ' &raquo; <a href="' . esc_url(get_term_link($cat)) . '">' . esc_html($cat->name) . '</a>';
        }

        // Titre
        echo ' &raquo; ' . esc_html(get_the_title());
    }

    // Archive catégorie
    elseif (is_category()) {
        $cat = get_queried_object();
        if ($cat && !is_wp_error($cat)) {
            $parents = array_reverse(get_ancestors($cat->term_id, 'category'));
            foreach ($parents as $parent_id) {
                $parent = get_term($parent_id, 'category');
                if ($parent && !is_wp_error($parent)) {
                    echo ' &raquo; <a href="' . esc_url(get_term_link($parent)) . '">' . esc_html($parent->name) . '</a>';
                }
            }
            echo ' &raquo; ' . esc_html(single_cat_title('', false));
        }
    }

    // Page
    elseif (is_page()) {
        $parents = array_reverse(get_post_ancestors(get_the_ID()));
        foreach ($parents as $parent_id) {
            echo ' &raquo; <a href="' . esc_url(get_permalink($parent_id)) . '">' . esc_html(get_the_title($parent_id)) . '</a>';
        }
        echo ' &raquo; ' . esc_html(get_the_title());
    }

    echo '</nav>';
}

/**
 * Sidebar Post Stream (infinite load sous la sidebar)
 * - JS dans /scripts.js (racine du theme)
 * - Endpoint AJAX: action=sidebar_post_stream
 */

/**
 * 1) Charger scripts.js + fournir ajaxUrl + nonce au JS
 */
add_action('wp_enqueue_scripts', function () {

  // Charge ton fichier /wp-content/themes/<theme>/scripts.js
  wp_enqueue_script(
    'theme-scripts',
    get_stylesheet_directory_uri() . '/scripts.js',
    [],
    '1.0',
    true
  );

  // Variables accessibles dans le JS via window.wpSidebarStream
  wp_localize_script('theme-scripts', 'wpSidebarStream', [
    'ajaxUrl' => admin_url('admin-ajax.php'),
    'nonce'   => wp_create_nonce('sidebar_post_stream'),
  ]);
});


/**
 * 2) Endpoint AJAX (connecté + non connecté)
 */
add_action('wp_ajax_sidebar_post_stream', 'hsls_sidebar_post_stream_ajax');
add_action('wp_ajax_nopriv_sidebar_post_stream', 'hsls_sidebar_post_stream_ajax');

/**
 * 3) Handler AJAX: renvoie du HTML d'extraits d'articles
 */
function hsls_sidebar_post_stream_ajax() {

  // Sécurité: vérifie le nonce envoyé par le JS
  check_ajax_referer('sidebar_post_stream', 'nonce');

  $page = isset($_POST['page']) ? max(1, (int) $_POST['page']) : 1;

  // Ajuste si tu veux filtrer autrement (catégorie, tag, etc.)
  $q = new WP_Query([
    'post_type'      => 'post',
    'post_status'    => 'publish',
    'paged'          => $page,
    'posts_per_page' => 4,
    'no_found_rows'  => false,
  ]);

  ob_start();

  if ($q->have_posts()) {
    while ($q->have_posts()) {
      $q->the_post();
      ?>
      <article class="sidebar-excerpt">
        <a class="sidebar-excerpt__title" href="<?php the_permalink(); ?>">
          <?php the_title(); ?>
        </a>
        <div class="sidebar-excerpt__meta">
          <?php echo esc_html(get_the_date()); ?>
        </div>
        <div class="sidebar-excerpt__text">
          <?php echo esc_html(wp_trim_words(get_the_excerpt(), 18, '…')); ?>
        </div>
      </article>
      <?php
    }
    wp_reset_postdata();
  }

  $html = ob_get_clean();

  // true quand on a atteint la dernière "page" de WP_Query
  $done = ($page >= (int) $q->max_num_pages);

  wp_send_json_success([
    'html' => $html,
    'done' => $done,
  ]);
}


/**
 * Google Map automatique sous le H1
 * Détecte la ville dans le titre via la table wp_villes
 */

add_filter('the_content', function ($content) {

  // Front uniquement
  if (is_admin()) return $content;

  // Seulement sur les articles
  if (!is_singular('post')) return $content;

  // Sécurité WP
  if (!in_the_loop() || !is_main_query()) return $content;

  global $wpdb;

  // 🔑 TA CLÉ GOOGLE (UNE SEULE FOIS)
  $api_key = defined('GOOGLE_MAPS_EMBED_API_KEY') ? GOOGLE_MAPS_EMBED_API_KEY : '';
  if (!$api_key) return $content;

  $title = get_the_title();
  if (!$title) return $content;

  // Normalisation simple
  $normalize = function($s){
    $s = iconv('UTF-8','ASCII//TRANSLIT//IGNORE',$s);
    $s = strtolower($s);
    $s = preg_replace('/[^a-z0-9 ]/',' ',$s);
    return ' ' . preg_replace('/\s+/',' ',trim($s)) . ' ';
  };

  $title_norm = $normalize($title);

  // Récupère les villes (cache 12h)
  $cities = get_transient('city_map_villes');
  if (!$cities) {
    $rows = $wpdb->get_col("SELECT ville FROM {$wpdb->prefix}villes");
    $cities = [];
    foreach ($rows as $v) {
      $cities[$normalize($v)] = $v;
    }
    // plus longues d'abord
    uksort($cities, fn($a,$b)=>strlen($b)-strlen($a));
    set_transient('city_map_villes', $cities, 12 * HOUR_IN_SECONDS);
  }

  $found_city = null;
  foreach ($cities as $norm => $city) {
    if (strpos($title_norm, $norm) !== false) {
      $found_city = $city;
      break;
    }
  }

  if (!$found_city) return $content;

  // HTML Google Map
  $map = '<div class="city-map" style="margin:15px 0 25px">';
  $map .= '<iframe width="100%" height="320" style="border:0" loading="lazy" allowfullscreen ';
  $map .= 'src="https://www.google.com/maps/embed/v1/place?key='.$api_key.'&q='.urlencode($found_city.', Belgique').'"></iframe>';
  $map .= '</div>';

  // 👉 Carte juste sous le H1
  return $map . $content;

}, 15);


