// Simple script to handle keyboard navigation for submenu accessibility

document.addEventListener('DOMContentLoaded', function() {
  const menu = document.querySelector('.menu');
  if (!menu) return;

  // Handle focus and blur to show/hide submenus for accessibility
  menu.querySelectorAll('li').forEach(item => {
    item.addEventListener('focusin', () => {
      item.classList.add('focus');
    });
    item.addEventListener('focusout', () => {
      item.classList.remove('focus');
    });
  });
});
