<?php get_header(); ?>

<main class="site-main container">
  <?php if (have_posts()) : ?>
    <section class="posts-list">
      <?php while (have_posts()) : the_post(); ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
          <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
          <div class="entry-summary">
            <?php the_excerpt(); ?>
          </div>
        </article>
      <?php endwhile; ?>
    </section>

    <nav class="pagination">
      <?php
      the_posts_pagination([
        'prev_text' => __('« Précédent'),
        'next_text' => __('Suivant »'),
      ]);
      ?>
    </nav>

  <?php else : ?>
    <p><?php _e('Aucun article trouvé.'); ?></p>
  <?php endif; ?>
</main>

<?php get_footer(); ?>
