<?php

// Active la prise en charge des widgets
function mon_theme_widgets_init() {
    register_sidebar( array(
        'name'          => 'Barre latérale principale',
        'id'            => 'sidebar-1',
        'description'   => 'Zone de widgets affichée dans la barre latérale.',
        'before_widget' => '<div id="%1$s" class="widget %2$s animate-on-scroll">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
}
add_action( 'widgets_init', 'mon_theme_widgets_init' );


function depannage_setup() {
  // Support titre automatique
  add_theme_support('title-tag');

  // Support miniatures
  add_theme_support('post-thumbnails');

  // Menus
  register_nav_menus([
    'primary' => __('Menu Principal'),
  ]);

  // Support HTML5
  add_theme_support('html5', ['search-form', 'comment-form', 'comment-list', 'gallery', 'caption']);
}

add_action('after_setup_theme', 'depannage_setup');

function depannage_scripts() {
  wp_enqueue_style('depannage-style', get_stylesheet_uri());
  wp_enqueue_script('depannage-script', get_template_directory_uri() . '/script.js', ['jquery'], null, true);
}
add_action('wp_enqueue_scripts', 'depannage_scripts');

// Menu responsive toggle
function depannage_menu_toggle_script() {
  ?>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const toggle = document.querySelector('.menu-toggle');
      const menu = document.getElementById('primary-menu');
      toggle.addEventListener('click', () => {
        const expanded = toggle.getAttribute('aria-expanded') === 'true' || false;
        toggle.setAttribute('aria-expanded', !expanded);
        menu.classList.toggle('active');
      });
    });
  </script>
  <?php
}


// Ajoute un champ image dans le formulaire d'ajout de catégorie
add_action('category_add_form_fields', function() {
    ?>
    <div class="form-field term-group">
        <label for="category-image"><?php _e('Image de la catégorie', 'textdomain'); ?></label>
        <input type="hidden" id="category-image" name="category-image" class="custom_media_url">
        <div id="category-image-wrapper"></div>
        <p>
            <input type="button" class="button button-secondary custom_media_button" id="custom_media_button" value="<?php _e('Ajouter une image', 'textdomain'); ?>" />
            <input type="button" class="button button-secondary custom_media_remove" value="<?php _e('Supprimer l\'image', 'textdomain'); ?>" />
        </p>
    </div>
    <?php
});

// Ajoute un champ image dans le formulaire d’édition de catégorie
add_action('category_edit_form_fields', function($term) {
    $image_id = get_term_meta($term->term_id, 'category-image-id', true);
    ?>
    <tr class="form-field term-group-wrap">
        <th scope="row"><label for="category-image"><?php _e('Image de la catégorie', 'textdomain'); ?></label></th>
        <td>
            <input type="hidden" id="category-image" name="category-image" value="<?php echo esc_attr($image_id); ?>">
            <div id="category-image-wrapper">
                <?php if ($image_id) echo wp_get_attachment_image($image_id, 'thumbnail'); ?>
            </div>
            <p>
                <input type="button" class="button button-secondary custom_media_button" id="custom_media_button" value="<?php _e('Ajouter une image', 'textdomain'); ?>" />
                <input type="button" class="button button-secondary custom_media_remove" value="<?php _e('Supprimer l\'image', 'textdomain'); ?>" />
            </p>
        </td>
    </tr>
    <?php
});

// Sauvegarde de l’image lors de la création/édition
add_action('created_category', function($term_id) {
    if (isset($_POST['category-image']) && '' !== $_POST['category-image']) {
        update_term_meta($term_id, 'category-image-id', absint($_POST['category-image']));
    }
});

add_action('edited_category', function($term_id) {
    if (isset($_POST['category-image']) && '' !== $_POST['category-image']) {
        update_term_meta($term_id, 'category-image-id', absint($_POST['category-image']));
    } else {
        delete_term_meta($term_id, 'category-image-id');
    }
});

// Script JS pour le média uploader
add_action('admin_footer', function() {
    if (!isset($_GET['taxonomy']) || $_GET['taxonomy'] != 'category') return;
    ?>
    <script>
    jQuery(document).ready(function($){
        function mediaUpload(button_class) {
            var _custom_media = true,
                _orig_send_attachment = wp.media.editor.send.attachment;
            $('body').on('click', button_class, function(e) {
                var button_id = $(this).attr('id');
                var send_attachment_bkp = wp.media.editor.send.attachment;
                var button = $(this);
                _custom_media = true;
                wp.media.editor.send.attachment = function(props, attachment){
                    if (_custom_media) {
                        $('#category-image').val(attachment.id);
                        $('#category-image-wrapper').html('<img class="custom_media_image" src="'+attachment.sizes.thumbnail.url+'" style="max-width:150px;"/>');
                    } else {
                        return _orig_send_attachment.apply(this, [props, attachment]);
                    }
                }
                wp.media.editor.open(button);
                return false;
            });
        }
        mediaUpload('.custom_media_button');
        $('body').on('click', '.custom_media_remove', function(){
            $('#category-image').val('');
            $('#category-image-wrapper').html('');
        });
    });
    </script>
    <?php
});

add_action('wp_footer', 'depannage_menu_toggle_script');
